﻿/* http://keith-wood.name/calendars.html
   Armenian localisation for Gregorian/Julian calendars for jQuery.
   Written by Levon Zakaryan (levon.zakaryan@gmail.com). */
(function($) {
	$.calendars.calendars.gregorian.prototype.regional['hy'] = {
		name: 'Gregorian',
		epochs: ['BCE', 'CE'],
		monthNames: ['Հունվար','Փետրվար','Մարտ','Ապրիլ','Մայիս','Հունիս',
		'Հուլիս','Օգոստոս','Սեպտեմբեր','Հոկտեմբեր','Նոյեմբեր','Դեկտեմբեր'],
		monthNamesShort: ['Հունվ','Փետր','Մարտ','Ապր','Մայիս','Հունիս',
		'Հուլ','Օգս','Սեպ','Հոկ','Նոյ','Դեկ'],
		dayNames: ['կիրակի','եկուշաբթի','երեքշաբթի','չորեքշաբթի','հինգշաբթի','ուրբաթ','շաբաթ'],
		dayNamesShort: ['կիր','երկ','երք','չրք','հնգ','ուրբ','շբթ'],
		dayNamesMin: ['կիր','երկ','երք','չրք','հնգ','ուրբ','շբթ'],
		dateFormat: 'dd.mm.yyyy',
		firstDay: 1,
		isRTL: false
	};
	if ($.calendars.calendars.julian) {
		$.calendars.calendars.julian.prototype.regional['hy'] =
			$.calendars.calendars.gregorian.prototype.regional['hy'];
	}
})(jQuery);
